



// --- Programme Arduino ---
// Trame de code générée par le générateur de code Arduino
// du site www.mon-club-elec.fr

// Auteur du Programme : X. HINAULT - Tous droits réservés
// Programme écrit le : 4/2/2011.

// ------- Licence du code de ce programme -----
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License,
//  or any later version.
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.

// ////////////////////  PRESENTATION DU PROGRAMME ////////////////////

// -------- Que fait ce programme ? ---------
 /* Ce programme reçoit sur le port série
une valeur numérique entière saisie dans le fenêtre Terminal du logiciel Arduino
et renvoie cette valeur sur le port Série pour affichage dans la fenêtre Terminal */

// --- Fonctionnalités utilisées ---

// Utilise la connexion série vers le PC

// -------- Circuit à réaliser ---------

// La connexion série vers le PC utilise les broches 0 et 1 (via le câble USB)


// /////////////////////////////// 1. Entête déclarative ///////////////////////
// A ce niveau sont déclarées les librairies incluses, les constantes, les variables, les objets utiles...

// --- Déclaration des constantes ---
int mon_heure ;
int mon_jour ;

// --- Inclusion des librairies ---
#include <RTClib.h>
#include <Wire.h>
RTC_DS1307 RTC;

// --- Déclaration des constantes utiles ---

// --- Déclaration des constantes des broches E/S numériques ---


// --- Déclaration des constantes des broches analogiques ---


// --- Déclaration des variables globales ---


// --- Déclaration des objets utiles pour les fonctionnalités utilisées ---


// ////////////////////////// 2. FONCTION SETUP = Code d'initialisation //////////////////////////
// La fonction setup() est exécutée en premier et 1 seule fois, au démarrage du programme

void setup()   { // debut de la fonction setup()

// --- ici instructions à exécuter 1 seule fois au démarrage du programme ---

     mon_heure = 0;
     mon_jour = 0 ;

// ------- Initialisation fonctionnalités utilisées -------  
    Wire.begin(); // lance la bibliothèque de transmission des dommées vers l'horloge
    Serial.begin(115200); // initialise connexion série à 115200 bauds vers le micro

    RTC.begin(); // initialise la bibliothèque avec la réérence RTC


// IMPORTANT : régler le terminal côté PC avec la même valeur de transmission


// ------- Broches en sorties numériques -------  

// ------- Broches en entrées numériques -------  

// ------- Activation si besoin du rappel au + (pullup) des broches en entrées numériques -------  

// ------- Initialisation des variables utilisées -------  

    // following line sets the RTC to the date & time this sketch was compiled
    RTC.adjust(DateTime(__DATE__, __TIME__)); // ajuste l'heure avec la date du micro ordinateur


} // fin de la fonction setup()
// ********************************************************************************

////////////////////////////////// 3. FONCTION LOOP = Boucle sans fin = coeur du programme //////////////////
// la fonction loop() s'exécute sans fin en boucle aussi longtemps que l'Arduino est sous tension

void loop(){ // debut de la fonction loop()


// --- ici instructions à exécuter par le programme principal ---
 
     DateTime now = RTC.now(); // fige les données de la date_heure

     mon_heure = now.hour() ; // lit l'heure figée
     mon_jour = now.day() ; // lit le jour figé
     Serial.print ("mon_heure =  ");
     Serial.println (mon_heure, DEC); // DEC sert à écrire en décimal
     Serial.print ("    mon_jour =  ");
     Serial.println  (mon_jour); // DEC sert à écrire en décimal

     Serial.print("    Numéro du jour: ");
     Serial.println(now.dayOfWeek()); // Retourne O et non pas 1 pour dimanche !

     
     delay (2000) ;

    Serial.println ("----------------------------");






} // fin de la fonction loop() - le programme recommence au début de la fonction loop sans fin
// ********************************************************************************


// ////////////////////////// FONCTIONS DE GESTION DES INTERRUPTIONS ////////////////////


// ////////////////////////// AUTRES FONCTIONS DU PROGRAMME ////////////////////



// ////////////////////////// Fin du programme ////////////////////

 
