



// --- Programme Arduino ---
// Trame de code générée par le générateur de code Arduino
// du site www.mon-club-elec.fr

// Auteur du Programme : X. HINAULT - Tous droits réservés
// Programme écrit le : 4/2/2011.

// ------- Licence du code de ce programme -----
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License,
//  or any later version.
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.

// ////////////////////  PRESENTATION DU PROGRAMME ////////////////////

// -------- Que fait ce programme ? ---------
 /* Ce programme reçoit sur le port série
une valeur numérique entière saisie dans le fenêtre Terminal du logiciel Arduino
et renvoie cette valeur sur le port Série pour affichage dans la fenêtre Terminal */

// --- Fonctionnalités utilisées ---

// Utilise la connexion série vers le PC

// -------- Circuit à réaliser ---------

// La connexion série vers le PC utilise les broches 0 et 1 (via le câble USB)


// /////////////////////////////// 1. Entête déclarative ///////////////////////
// A ce niveau sont déclarées les librairies incluses, les constantes, les variables, les objets utiles...

// --- Déclaration des constantes ---
int mon_heure ;
int ma_minute ;
int ma_seconde ;

int mon_jour ;
int mon_mois ;
int mon_annee ; 

int mon_jour_semaine ; 
float variable_minute ;

int led_rouge;
int led_verte;

// --- Inclusion des librairies ---
#include <RTClib.h>
#include <Wire.h>
RTC_DS1307 RTC;

// --- Déclaration des constantes utiles ---

// --- Déclaration des constantes des broches E/S numériques ---


// --- Déclaration des constantes des broches analogiques ---


// --- Déclaration des variables globales ---


// --- Déclaration des objets utiles pour les fonctionnalités utilisées ---


// ////////////////////////// 2. FONCTION SETUP = Code d'initialisation //////////////////////////
// La fonction setup() est exécutée en premier et 1 seule fois, au démarrage du programme

void setup()   { // debut de la fonction setup()

// --- ici instructions à exécuter 1 seule fois au démarrage du programme ---

     mon_heure = 0;
     ma_minute = 0 ;
     ma_seconde = 0;
     mon_jour = 0 ;
     mon_mois = 0 ;
     mon_annee = 0 ;  // attention pas d'accent à année => annee
     //mon_jour_semaine ;   
     variable_minute = 0;

     

// ------- Initialisation fonctionnalités utilisées -------  
    Wire.begin(); // lance la bibliothèque de transmission des dommées vers l'horloge
    Serial.begin(115200); // initialise connexion série à 115200 bauds vers le micro

    RTC.begin(); // initialise la bibliothèque avec la réérence RTC


// IMPORTANT : régler le terminal côté PC avec la même valeur de transmission


// ------- Broches en sorties numériques -------  

// ------- Broches en entrées numériques -------  

// ------- Activation si besoin du rappel au + (pullup) des broches en entrées numériques -------  

// ------- Initialisation des variables utilisées -------  

    // following line sets the RTC to the date & time this sketch was compiled
    RTC.adjust(DateTime(__DATE__, __TIME__)); // ajuste l'heure avec la date du micro ordinateur


} // fin de la fonction setup()
// ********************************************************************************

////////////////////////////////// 3. FONCTION LOOP = Boucle sans fin = coeur du programme //////////////////
// la fonction loop() s'exécute sans fin en boucle aussi longtemps que l'Arduino est sous tension

void loop(){ // debut de la fonction loop()


// --- ici instructions à exécuter par le programme principal ---
 
     DateTime now = RTC.now(); // fige les données de la date_heure

     mon_heure = now.hour() ; // lit l'heure figée
     ma_minute = now.minute();
     ma_seconde = now.second() ; // lit le jour figé

     mon_jour = now.day() ; 
     mon_mois = now.month() ; 
     mon_annee = now.year() ; 


     Serial.print ("\t");
     Serial.print (mon_jour, DEC); // DEC sert à écrire en décimal
     Serial.print ("\t");
     Serial.print  (mon_mois, DEC); // DEC sert à écrire en décimal
     Serial.print ("\t");
     Serial.print  (mon_annee, DEC); // DEC sert à écrire en décimal
     Serial.print ("\t");     

     Serial.print (mon_heure, DEC); // DEC sert à écrire en décimal
     Serial.print ("\t");
     Serial.print (ma_minute, DEC); // DEC sert à écrire en décimal
     Serial.print ("\t");
     Serial.print (ma_seconde, DEC); // DEC sert à écrire en décimal
     Serial.print ("\t");

     variable_minute = ma_minute/2;
     variable_minute = floor (variable_minute) ;
     Serial.print (variable_minute); // 
     Serial.print ("\t");

if (variable_minute *2 == ma_minute)
{
 Serial.print ("minute paire");
}
else
{
 Serial.print ("minute impaire");
}
     delay (2000) ;

    Serial.println ();






} // fin de la fonction loop() - le programme recommence au début de la fonction loop sans fin
// ********************************************************************************


// ////////////////////////// FONCTIONS DE GESTION DES INTERRUPTIONS ////////////////////


// ////////////////////////// AUTRES FONCTIONS DU PROGRAMME ////////////////////



// ////////////////////////// Fin du programme ////////////////////

 
