// Librairie Wire - Master Writer (Maitre ecrit)
// par Nicholas Zambetti <http://www.zambetti.com>
// Traduction par MCHobby.be <http://www.mchobby.be>
// Montage & tutoriel détaillé disponibles sur 
//    http://mchobby.be/wiki/index.php?title=Arduino_I2C_Intro-Montage
// 
// Démontre l'usage de la librairie Wire.
// Ecrit des données vers un périphérique esclave I2C/TWI
//
// A utiliser avec le programme esclave de cet exemple.
//
// Crée le 29 mars 2006
// Traduit le 9 mars 2013 (MCHobby)
//
// This example code is in the public domain.
// Ce code d'exemple fait partie du domaine public.
//
#include <Wire.h>
#include <Servo.h>

Servo servoBas;  // Servomoteur pilotant l'azimuth
Servo servoHaut; // Servomoteur pilotant l'elevation

void setup()
{
  Wire.begin(4);                // Joindre le Bus I2C avec adresse #4
  Wire.onReceive(receiveEvent); // enregistrer l'événement (lorsqu'une demande arrive)
  Serial.begin(9600);           // Démarrer une communication série
}

void loop()
{
  delay(100);
}

// Fonction qui est exécutée lorsque des données sont envoyées par le Maître.
// Cette fonction est enregistrée comme un événement ("event" en anglais), voir la fonction setup()
void receiveEvent(int howMany)
{
  
  while(2 < Wire.available()) // Lire tous les octets sauf le dernier
  {
    char c = Wire.read();     // lecture de l'octet/byte comme caractère
    Serial.print(c);          // afficher le caractère
  }
  int x = Wire.read();        // lecture de l'octet/byte ignoré comme un entier
  Serial.println(x);  // Afficher la valeur numérique
  int y = Wire.read();        // lecture de l'octet/byte ignoré comme un entier
  Serial.println(y);  
}

void w_servo(int servo, int val) {
  switch(servo) { // Selection du servomoteur
    case 0: 
      servoBas.write(limitS(0,val));                  
      break;
    case 1:
      servoHaut.write(limitS(1,val));
      break;
  }
}

int limitS(int i, int angle) {  // i=0 pour le servo du bas, i=1 pour le servo du haut 
  
  int angle2 = angle; // Nouvel angle de sortie
  // Declaration de variables qui seront les limites angulaires du servomoteur (en degres)
  int limBasse;
  int limHaute;
  
  // Definition des limites angulaires selon le servomoteur (en degrés)
  switch(i) {
    case 0: // Servomoteur du bas 
      limBasse = 5;
      limHaute = 175;
      break;
    case 1: // Servomoteur du haut
      limBasse = 90;
      limHaute = 175;
      break;
    default: break;
  }

  // Si l'angle demande au servo depasse les limites, on fixe cet angle a la limite depassee
  if (angle > limHaute) {
    angle2 = limHaute;
  }
   if (angle < limBasse) {
    angle2 = limBasse;
  }

  return angle2;
  
}

void asserv(){

  int angleActuel0;
  int angleNouveau0;
  int angleActuel1;
  int angleNouveau1;
  
if (Serial.available()>0){

angleNouveau0 = Serial.read();

angleActuel1;


w_servo(0,angleNouveau0);
w_servo(1,angleNouveau1); 

}
}
