  #define captD 2
  #define captG 3
  #define enA 5
  #define in1 6
  #define in2 7
  #define in3 8
  #define in4 9
  #define enB 10
  #define Echo 11
  #define Trig 12
  
  #define minDistance 40
  #define fastSpeed 0.6f;
  #define slowSpeed 0.4f;
  
  int valcaptG;
  int valcaptD;
  int oldcaptG;
  int oldcaptD;

  float rw;
  float lw;
  
  float distance;

void setup()
{
  pinMode(Echo, INPUT);
  pinMode(captD, INPUT);
  pinMode(captG, INPUT);

  pinMode(Trig, OUTPUT);
  pinMode(enA, OUTPUT);
  pinMode(in1, OUTPUT);
  pinMode(in2, OUTPUT);
  pinMode(enB, OUTPUT);
  pinMode(in3, OUTPUT);
  pinMode(in4, OUTPUT);
  
  digitalWrite(Trig, LOW);
  analogWrite(enA, 0);
  analogWrite(enB, 0);

  float rw = 0;
  float lw = 0;
  oldcaptG = 2;
  oldcaptD = 2;
  
  delay(1000);
}

void loop()
{
  digitalWrite(Trig, HIGH);
  delayMicroseconds(10);
  digitalWrite(Trig, LOW);
  distance = pulseIn(Echo, HIGH)*17/1000;

  if (distance < minDistance)
    return;
  
  valcaptD = digitalRead(captD);
  valcaptG = digitalRead(captG);

  if (oldcaptD != valcaptD)
  {
    if (valcaptD)
    {
      rw = fastSpeed;
      digitalWrite(in3, HIGH);
      digitalWrite(in4, LOW);
    }
    else
    {
      rw = slowSpeed;
      digitalWrite(in3, LOW);
      digitalWrite(in4, HIGH);
    }
  }
  oldcaptD = valcaptD;

  if (oldcaptG != valcaptG)
  {
    if (valcaptG)
    {
      lw = fastSpeed;
      digitalWrite(in1, HIGH);
      digitalWrite(in2, LOW);
    }
    else
    {
      lw = slowSpeed;
      digitalWrite(in1, LOW);
      digitalWrite(in2, HIGH);
    }
  }
  oldcaptG = valcaptG;
  
  analogWrite(enA, 255 * lw);
  analogWrite(enB, 255 * rw);
}
