/*
  Blink_Chicken
  Runs LEDs in different patterns
 */
 

int nLeds = 6;
int ledPins[] = {5, 6, 9, 10, 11, 16};
int buttonPin = 17;
int nPatterns = 3;
int lightPattern = 1;
int oldButtonVal = 0;

// the setup routine runs once when you press reset:
void setup() {                
  // initialize the digital pin as an output.
  for (int i = 0; i < nLeds; i++) pinMode(ledPins[i], OUTPUT);
  pinMode(buttonPin, INPUT);
  digitalWrite(buttonPin, HIGH);  //Keep the button pin high, so it will drop to 0
                                  //if pressed.
  // initialize serial communication at 9600 bits per second:
  //Serial.begin(9600);
}

// Pattern 1 - light up pins in turn, one set at a time
void pattern1() {
    for (int i = 0; i < nLeds; i++) {
    digitalWrite(ledPins[i], HIGH);
    delay(50);
    digitalWrite(ledPins[i], LOW);
  }
}


// Pattern 2 - random on/off
void pattern2() {
     int randomLed = floor(random(0, nLeds));
     int randVal = floor(random(0, 2));
     if (randVal == 0)
       digitalWrite(ledPins[randomLed], LOW);
     else
       digitalWrite(ledPins[randomLed], HIGH);
    delay(10);
}

// Pattern 3 - all on, then all off
void pattern3() {
   for (int i = 0; i < nLeds; i++) {  // Turn 'em all on
     digitalWrite(ledPins[i], HIGH);
     delay(50);
  }
  delay(200);
  for (int i = 0; i < nLeds; i++) {   // Now turn 'em all off
     digitalWrite(ledPins[i], LOW);
     delay(50);
  }
}

// the loop routine runs over and over again forever:
void loop() {
  int buttonVal = digitalRead(buttonPin);
  if (buttonVal == LOW && oldButtonVal == HIGH) {// Button has just been pressed
    lightPattern = lightPattern + 1;
  }
  if (lightPattern > nPatterns) lightPattern = 1;  
  oldButtonVal = buttonVal;

//  Serial.print("Light pattern = ");
//  Serial.println(lightPattern);

  switch(lightPattern) {
    case 1: 
      pattern1();
      break;
    case 2: 
      pattern2();
      break;
    case 3: 
      pattern3();
      break;
    default: 
      pattern3();
      break;
  }
}
