#!/bin/bash

filename='sources.list'
nline=1

ntmp='/tmp/line_number'
ltmp='/tmp/line_test'
line_write="deb http://*debian.org/debian/ bullseye"

while read line;
do
    nline=$((nline+1))
done < $filename

sed -i "s/# deb/deb/" $filename
sed -i "s/#deb/deb/" $filename
sed -i "s/deb cdrom/# deb cdrom/" $filename

cat $filename | grep  "$line_write" > $ltmp

while read line;
do
    if [[ "$line_write" == "$line" ]]
    then
        exit 1
    fi
done < $ltmp


head -$nline $filename | grep  "http://deb.debian.org/debian/ bullseye-updates" \
    >> $filename

cat $filename | grep -n "http://deb.debian.org/debian/ bullseye-updates" \
    | cut -d ":" -f 1 >> $ntmp


head -$nline $filename | grep  "http://security.debian.org/debian-security bullseye-security" \
    >> $filename

cat $filename | grep -n "http://security.debian.org/debian-security bullseye-security" \
    | cut -d ":" -f 1 >> $ntmp


while read number;
do
    if [ $number -ge $nline ]
    then
        sed -i "$((number+0))s/bullseye-updates main/bullseye main contrib non-free/" $filename

        sed -i "$((number+0))s/bullseye-security/bullseye-backports/" $filename

        sed -i "$((number+0))s/security.debian/deb.debian/" $filename

    fi
done < $ntmp

rm $ntmp $ltmp

apt update

dpkg -s curl
if [ $? -ne 0 ]
then
    apt install -y curl
fi

dpkg -s wget
if [ $? -ne 0 ]
then
    apt install -y wget
fi

dpkg -s tilix
if [ $? -ne 0 ]
then
    apt install -y tilix
fi

dpkg -s git
if [ $? -ne 0 ]
then
    apt install -y git
fi

dpkg -s zsh
if [ $? -ne 0 ]
then
    apt install -y zsh
    chsh -s /bin/zsh root
fi

#redémarrer le PC après cette commande

dpkg -s tweak
if [ $? -ne 0 ]
then
    apt install -y tweak
fi

dpkg -s firmware-iwlwifi
if [ $? -ne 0 ]
then
    apt install -y firmware-iwlwifi
fi

dpkg -s systemd-timesyncd
if [ $? -ne 0 ]
then
    apt install -y systemd-timesyncd
    sed "s/^#NTP=/NTP=ntp.u-bordeaux.fr/" /etc/systemd/timesyncd.conf
    timedatectl set-ntp on
fi


#pour avoir le bon $USER il faut faire la
#commande sudo -u <user>
# echo $USER
# chsh -s /bin/zsh $USER


ls /usr/share/keyrings/vscodium-archive-keyring.asc
if [ $? -ne 0 ]
then
    curl https://gitlab.com/paulcarroty/vscodium-deb-rpm-repo/raw/master/pub.gpg > pub.gpg
    mv pub.gpg /usr/share/keyrings/vscodium-archive-keyring.asc
fi

ls /etc/apt/sources.list.d/vscodium.list
if [ $? -ne 0 ]
then
    echo 'deb [ signed-by=/usr/share/keyrings/vscodium-archive-keyring.asc ] https://paulcarroty.gitlab.io/vscodium-deb-rpm-repo/debs vscodium main' | sudo tee /etc/apt/sources.list.d/vscodium.list
fi

dpkg -s codium
if [$? -ne 0 ]
then
    apt update
    apt install -y codium codium-insiders
fi

dpkg -s python3-venv
if [ $? -ne 0 ]
then
    apt install python3-venv
fi

cat /usr/share/codium/resources/app/product.json | grep "m/_apis/public/gallery\",\n    \"cacheUrl\": \"https://vscode.blob"
if [ $? -ne 0 ]
then
    memoire=/tmp/memoire
    cat /usr/share/codium/resources/app/product.json | grep -n "extensionsGallery" \
        | cut -d ":" -f 1 > tmp.tmp

    while read line
    do
        sed -i "$((line+3))i\    ,\"serviceUrl\": \"https://marketplace.visualstudio.com/_apis/public/gallery\",\n    \"cacheUrl\": \"https://vscode.blob.core.windows.net/gallery/index\",\n    \"itemUrl\": \"https://marketplace.visualstudio.com/items\"\n" /usr/share/codium/resources/app/product.json
    done < tmp.tmp
fi

ls $HOME/.oh-my-zsh
if [ $? -ne 0 ]
then
    sh -c "$(curl -fsSL https://raw.githubusercontent.com/ohmyzsh/ohmyzsh/master/tools/install.sh)"
    yes y
fi

ls $HOME/.zshrc
if [ $? -eq 0 ]
then
    sed -i "s/ZSH_THEME=\"robbyrussell\"/ZSH_THEME=\"ys\"/" $HOME/.zshrc
fi

echo "pour terminer l'install ouvrez vs code (codium) et téléchargez platformio"
