#!/bin/bash

apt update

dpkg -s curl
if [ $? -ne 0 ]
then
    apt install curl
fi

dpkg -s git
if [ $? -ne 0 ]
then
    apt install git
fi

dpkg -s zsh
if [ $? -ne 0 ]
then
    apt install zsh
    chsh -s /bin/zsh root
fi

#redémarrer le PC après cette commande

#pour avoir le bon $USER il faut faire la
#commande sudo -u <user>
echo $USER
chsh -s /bin/zsh $USER

ls $HOME/.oh-my-zsh
if [ $? -ne 0 ]
then
    sh -c "$(curl -fsSL https://raw.githubusercontent.com/ohmyzsh/ohmyzsh/master/tools/install.sh)"
    \n
fi

ls $HOME/.zshrc
if [ $? -eq 0 ]
then
    sed -i "s/ZSH_THEME=\"robbyrussell\"/ZSH_THEME=\"ys\"/" $HOME/.zshrc
fi

ls /usr/share/keyrings/vscodium-archive-keyring.asc
if [ $? -ne 0 ]
then
    curl https://gitlab.com/paulcarroty/vscodium-deb-rpm-repo/raw/master/pub.gpg > pub.gpg
    mv pub.gpg /usr/share/keyrings/vscodium-archive-keyring.asc
fi

ls /etc/apt/sources.list.d/vscodium.list
if [ $? -ne 0 ]
then
    echo 'deb [ signed-by=/usr/share/keyrings/vscodium-archive-keyring.asc ] https://paulcarroty.gitlab.io/vscodium-deb-rpm-repo/debs vscodium main' | sudo tee /etc/apt/sources.list.d/vscodium.list
fi

dpkg -s codium
if [$? -ne 0 ]
then
    apt update
    apt install codium codium-insiders
fi

