#!/bin/bash

filename='/etc/apt/sources.list'
nline=1

ntmp='/tmp/line_number'
ltmp='/tmp/line_test'
line_write="deb http://deb.debian.org/debian/ bullseye main"

while read line;
do
    nline=$((nline+1))
done < $filename

sed -i "s/# deb/deb/" $filename
sed -i "s/deb cdrom/# deb cdrom/" $filename

cat $filename | grep  "$line_write" > $ltmp

while read line;
do
    if [[ "$line_write" == "$line" ]]
    then
        exit 1
    fi
done < $ltmp

head -$nline $filename | grep  "http://deb.debian.org/debian/ bullseye-updates" \
    >> $filename

cat $filename | grep -n "http://deb.debian.org/debian/ bullseye-updates" \
    | cut -d ":" -f 1 > $ntmp
while read number;
do
    if [ $number -ge $nline ]
    then
        sed -i "$((number+0))s/bullseye-updates/bullseye/" $filename
    fi
done < $ntmp

rm $ntmp $ltmp
