/*********************************************
 Utilitaires de conversions physique -> steps
*********************************************/

/**
 * @brief Convertit une longueur en cm vers un nombre de pas moteur.
 *
 * Exemple
 * ```
 * float distance = 22.3; //cm
 * int steps = convertLengthToSteps(distance);
 * ```
 *
 * @param length
 * @return int
 */
int convertLengthToSteps(float length)
{
    float result = length * 512 / (4 * 3.1415);
    return int(result);
}

/**
 * @brief Convertit une rotation en degrés vers un nombre de pas moteur.
 *
 * Exemple
 * ```
 * float angle = 45; //deg
 * int steps = convertRotToSteps(angle);
 * ```
 *
 * @param rotation Angle en degrés.
 * @return int Nombres de pas pour les moteurs.
 */
int convertRotToSteps(int rotation)
{
    int result = convertLengthToSteps(rotation * 3.1415 / 180 * 7.8);
    return result;
}