// Ce programme permet de se connecter depuis notre smartphone, tablette ou ordinateur au WIFI de l'ESP 32 en local. 
// La page html correspond à l'adresse 192.168.4.1
// On peut y controler la vitesse d'un moteur à courant continu
// Il y a un bouton Download qui permettra de télécharger un fichier.txt contenant l'heure, la température, l'humidité et la vitesse en tr/min

// Load Wi-Fi library
#include <WiFi.h>

// Replace with your network credentials
const char* ssid     = "beta2";
const char* password = "123456789";

int motor1Pin1 = 27; 
int motor1Pin2 = 26; 
int enable1Pin = 14; 

// Setting PWM properties
const int freq = 30000;
const int pwmChannel = 0;
const int resolution = 8;
int speed = 0;

// Set web server port number to 80
WiFiServer server(80);

// Variable to store the HTTP request
String header;

void setup() {
  Serial.begin(9600);

  // Connect to Wi-Fi network with SSID and password
  Serial.print("Setting AP (Access Point)…");
  // Remove the password parameter, if you want the AP (Access Point) to be open
  WiFi.softAP(ssid, password);

  IPAddress IP = WiFi.softAPIP();
  Serial.print("AP IP address: ");
  Serial.println(IP);
  
  server.begin();

    // sets the pins as outputs:
  pinMode(motor1Pin1, OUTPUT);
  pinMode(motor1Pin2, OUTPUT);
  pinMode(enable1Pin, OUTPUT);
  
  // configure LED PWM functionalitites
  ledcSetup(pwmChannel, freq, resolution);
  
  // attach the channel to the GPIO to be controlled
  ledcAttachPin(enable1Pin, pwmChannel);
  ledcWrite(pwmChannel,speed);   
  
}

void loop(){

  WiFiClient client = server.available();   // Listen for incoming clients

  if (client) {                             // If a new client connects,
    Serial.println("New Client.");          // print a message out in the serial port
    String currentLine = "";                // make a String to hold incoming data from the client
    while (client.connected()) {            // loop while the client's connected
      if (client.available()) {             // if there's bytes to read from the client,
        char c = client.read();             // read a byte, then
        Serial.write(c);                    // print it out the serial monitor
        header += c;
        if (c == '\n') {                    // if the byte is a newline character
          // if the current line is blank, you got two newline characters in a row.
          // that's the end of the client HTTP request, so send a response:
          if (currentLine.length() == 0) {
            // HTTP headers always start with a response code (e.g. HTTP/1.1 200 OK)
            // and a content-type so the client knows what's coming, then a blank line:
            client.println("HTTP/1.1 200 OK");
            client.println("Content-type:text/html");
            client.println("Connection: close");
            client.println();
            
            // turns the GPIOs on and off
            if (header.indexOf("GET /setSpeed?speed=255") >= 0) {
              speed = 255;
              ledcWrite(pwmChannel,speed);   
            }else if(header.indexOf("GET /setSpeed?speed=200") >= 0){
              speed = 200;
              ledcWrite(pwmChannel,speed);  
            }else if(header.indexOf("GET /setSpeed?speed=150") >= 0){
              speed = 150;
              ledcWrite(pwmChannel,speed);  
            }else if(header.indexOf("GET /setSpeed?speed=50") >= 0){
              speed = 50;
              ledcWrite(pwmChannel,speed);  
            }else if(header.indexOf("GET /setSpeed?speed=0") >= 0){
              speed = 0;
              ledcWrite(pwmChannel,speed);  
            }

            
            // Display the HTML web page
            client.println("<!DOCTYPE html><html>");
            client.println("<head><meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">");
            client.println("<link rel=\"icon\" href=\"data:,\">");
            // CSS to style the on/off buttons 
            // Feel free to change the background-color and font-size attributes to fit your preferences
            client.println("<style>html { font-family: Helvetica;  margin: 0px auto; text-align: center;}");
            client.println(".button { background-color: #a2de96; border: none; color: white; padding: 16px 40px;");
            client.println("text-decoration: none; font-size: 30px; margin: 2px; cursor: pointer;}");
            client.println("</style></head>");
            
            // Web Page Heading
            client.println("<body><h1>Capteur de spores IFV</h1>");
            
            client.println("<p><a href=\"/download\"><button class=\"button\">Download</button></a></p>");
            client.println("<FORM action=\"/setSpeed\" method=\"get\" id=\"speedForm\"><p>Vitesse : </p><SELECT id=\"selectSpeed\" onChange=\"updateSpeed()\" name=\"speed\" size=\"1\">");
            client.println("<OPTION>255");
            client.println("<OPTION>200");
            client.println("<OPTION>150");
            client.println("<OPTION>50");
            client.println("<OPTION>0");
            client.println("</SELECT></FORM>");
            client.println("<script>function updateSpeed(){document.getElementById(\"speedForm\").submit();}");
            client.println("let element = document.getElementById(\"selectSpeed\");");
            client.println("element.value = "+ String(speed) +";</script>");
            client.println("</body></html>");
            
            // The HTTP response ends with another blank line
            client.println();
            // Break out of the while loop
            break;
          } else { // if you got a newline, then clear currentLine
            currentLine = "";
          }
        } else if (c != '\r') {  // if you got anything else but a carriage return character,
          currentLine += c;      // add it to the end of the currentLine
        }
      }
    }
    // Clear the header variable
    header = "";
    // Close the connection
    
    client.stop();
    Serial.println("Client disconnected.");
    Serial.println("");
  }
}
