/*******************************************
 Initialisation et fonctions de déplacement
*******************************************/

/**
 * @brief Configure les ports de contrôle des moteurs sont des sorties (output).
 *
 */
void setupPins()
{
    pinMode(IN1a, OUTPUT);
    pinMode(IN2a, OUTPUT);
    pinMode(IN3a, OUTPUT);
    pinMode(IN4a, OUTPUT);

    pinMode(IN1b, OUTPUT);
    pinMode(IN2b, OUTPUT);
    pinMode(IN3b, OUTPUT);
    pinMode(IN4b, OUTPUT);
}

/**
 * @brief Applique une configuration aux moteurs.
 * @brief Chaque configuration est sur 1 octet.
 *
 * Exemple
 * ```
 * writeMotor(0b0010, 0b1100);
 * ```
 *
 * @param left Configuration du moteur droit (ex: `0b1100`).
 * @param right Configuration du moteur droit (ex: `0b0101`).
 */
void writeMotor(uint8_t left, uint8_t right)
{
    digitalWrite(IN4a, left & 0b1000);
    digitalWrite(IN3a, left & 0b0100);
    digitalWrite(IN2a, left & 0b0010);
    digitalWrite(IN1a, left & 0b0001);
    digitalWrite(IN4b, right & 0b1000);
    digitalWrite(IN3b, right & 0b0100);
    digitalWrite(IN2b, right & 0b0010);
    digitalWrite(IN1b, right & 0b0001);
}

/**
 * @brief Commande pour faire avancer le robot.
 *
 */
void forward()
{
    writeMotor(0b1000, 0b0001);
    delay(DELAY_TIME);
    writeMotor(0b0100, 0b0010);
    delay(DELAY_TIME);
    writeMotor(0b0010, 0b0100);
    delay(DELAY_TIME);
    writeMotor(0b0001, 0b1000);
    delay(DELAY_TIME);
}

/**
 * @brief Commande pour faire reculer le robot.
 *
 */
void backward()
{
    writeMotor(0b0001, 0b1000);
    delay(DELAY_TIME);
    writeMotor(0b0010, 0b0100);
    delay(DELAY_TIME);
    writeMotor(0b0100, 0b0010);
    delay(DELAY_TIME);
    writeMotor(0b1000, 0b0001);
    delay(DELAY_TIME);
}

/**
 * @brief Commande pour faire tourner le robot à droite.
 *
 */
void right()
{
    writeMotor(0b1000, 0b1000);
    delay(DELAY_TIME);
    writeMotor(0b0100, 0b0100);
    delay(DELAY_TIME);
    writeMotor(0b0010, 0b0010);
    delay(DELAY_TIME);
    writeMotor(0b0001, 0b0001);
    delay(DELAY_TIME);
}

/**
 * @brief Commande pour faire tourner le robot à gauche.
 *
 */
void left()
{
    writeMotor(0b0001, 0b0001);
    delay(DELAY_TIME);
    writeMotor(0b0010, 0b0010);
    delay(DELAY_TIME);
    writeMotor(0b0100, 0b0100);
    delay(DELAY_TIME);
    writeMotor(0b1000, 0b1000);
    delay(DELAY_TIME);
}

/**
 * @brief Commande pour arrêter les  moteurs du robot.
 *
 */
void stopMotors()
{
    writeMotor(0b0000, 0b0000);
}