// Librairies utilisées dans le code :
#include <AsyncTCP.h>
#include <ESPAsyncWebServer.h>
#include <WiFi.h>

// Libraries locales pour configurer et contrôler le robot.
#include "config.h"   // Configuration des entrées/sorties et delais.
#include "controls.h" // Fonctions pour se déplacer.
#include "convert.h"  // Utilitaires pour convertir des mesures en steps.
#include "server.hpp" // Configure et demarre le server HTTP.

// État global de la commande en cours
command_t command = {.running = false, .stopped = false};

// Création du serveur asynchrone :
AsyncWebServer server(80);

// Code exécuté au démarrage (paramétrage) :
void setup()
{
  setupPins();                   // Configure les pins de l'ESP32
  Serial.begin(115200);          // Démarrage d'une communication Série avec l'ordinateur s'il est connecté
  connectWiFi(WiFi);             // Connexion au wifi
  serverConfig(server, command); // Configuration du serveur
  server.begin();                // Démarrage du serveur
}

// Code exécuté en boucle jusqu'à l'extinction du robot
void loop()
{
  // Ne rien faire si aucune commande en cours
  if (!command.running)
    return;

  // Arrêter le robot si une commande est interrompue
  // ou si le nombre de pas a été effectué
  if (command.stopped || command.value <= 0)
  {
    Serial.println("stop");
    command.running = false;
    command.stopped = false;
    stopMotors();
    return;
  }

  // Sinon executer la commande en cours
  updateCommand(command); // Met à jour la commande global
  if (command.value > 0)
  { // S'il reste des pas à effectuer alors on l'affiche et on enlève un pas
    Serial.print(command.name);
    Serial.print(": ");
    Serial.println(command.value);
    command.value--;
  }
}

// Met à jour l'état du robot en fonction de la commande en cours.
void updateCommand(command_t &command)
{
  if (command.name == "forward")
  {
    forward();
  }
  else if (command.name == "left")
  {
    left();
  }
  else if (command.name == "right")
  {
    right();
  }
  else if (command.name == "backward")
  {
    backward();
  }
}