#include <Arduino.h>
#include "Arduino_GFX_Library.h"
#include "pin_config.h"
#include "SensorPCF85063.hpp"
#include <Wire.h>

#include "HWCDC.h"

#define BUTTON_PIN 0
HWCDC USBSerial;

SensorPCF85063 rtc;
bool isPaused = false;
int timerP = -1;
int MAX_TIMER = 1 * 60;
uint32_t lastMillis;
char previousTimeString[20] = "";
Arduino_DataBus *bus = new Arduino_ESP32SPI(LCD_DC, LCD_CS, LCD_SCK, LCD_MOSI);

Arduino_GFX *gfx = new Arduino_ST7789(bus, LCD_RST /* RST */,
                                      0 /* rotation */, true /* IPS */, LCD_WIDTH, LCD_HEIGHT, 0, 20, 0, 0);

int16_t getCenteredX(const char *text, uint8_t textSize) {
  int16_t textWidth = strlen(text) * 6 * textSize;  // 6 pixels per character in default size
  return (LCD_WIDTH - textWidth) / 2;
}

void setup() {
  USBSerial.begin(115200);
  pinMode(BUTTON_PIN, INPUT_PULLUP);

  gfx->begin();
  gfx->fillScreen(WHITE);
  pinMode(LCD_BL, OUTPUT);
  digitalWrite(LCD_BL, HIGH);

  gfx->fillRect(0, 150, LCD_WIDTH, 50, WHITE);  // Clear the area for the time
  gfx->setTextColor(BLACK);
  gfx->setTextSize(3, 3, 0);

  int16_t timeX = getCenteredX("00:00 100%", 3);
  gfx->setCursor(timeX, 150);  // Adjust Y-coordinate as needed
  gfx->println("00:00 100%");  // Display the new time
  if (!rtc.begin(Wire, PCF85063_SLAVE_ADDRESS, IIC_SDA, IIC_SCL)) {
    USBSerial.println("Failed to find PCF8563 - check your wiring!");
    while (1) {
      delay(1000);
    }
  }
}

void loop() {
  int buttonState = digitalRead(BUTTON_PIN);

  if (buttonState == LOW) {
    while (buttonState == LOW) { buttonState = digitalRead(BUTTON_PIN); }
    bool keepgoing = true;

    int timer = -1;
    gfx->begin();
    gfx->fillScreen(WHITE);
    pinMode(LCD_BL, OUTPUT);
    digitalWrite(LCD_BL, HIGH);

    while (keepgoing) {
      buttonState = digitalRead(BUTTON_PIN);

      if (buttonState == LOW) {
        while (buttonState == LOW) {
          buttonState = digitalRead(BUTTON_PIN);
        }

        if (!isPaused) {
          timerP = timer;
        }
        isPaused = !isPaused;
      }

      if (millis() - lastMillis > 1000) {
        lastMillis = millis();
        if (!isPaused) {
          timer++;
        }
        // Format the current time as a string
        char timeString[20];

        double percentValue;
        if (isPaused) {
          percentValue = 1.0 - (static_cast<double>(timerP) / static_cast<double>(MAX_TIMER));
          sprintf(timeString, "%02d:%02d %d%%", timerP / 60, timerP % 60, static_cast<int>(percentValue * 100));
        } else {
          percentValue = 1.0 - (static_cast<double>(timer) / static_cast<double>(MAX_TIMER));
          sprintf(timeString, "%02d:%02d %d%%", timer / 60, timer % 60, static_cast<int>(percentValue * 100));
          if (timer == MAX_TIMER) {
            keepgoing = false;
          }
        }



        // Only update the time if it has changed
        if (strcmp(timeString, previousTimeString) != 0) {
          // Clear the previous time area by filling a small rectangle
          gfx->fillRect(0, 150, LCD_WIDTH, 50, WHITE);  // Clear the area for the time
          gfx->setTextColor(BLACK);
          gfx->setTextSize(3, 3, 0);

          int16_t timeX = getCenteredX(timeString, 3);
          gfx->setCursor(timeX, 150);  // Adjust Y-coordinate as needed
          gfx->println(timeString);    // Display the new time

          // Save the current time as the previous time
          strcpy(previousTimeString, timeString);
        }
      }
    }
  }
}
