#include <Arduino.h>
#include "Arduino_GFX_Library.h"
#include "pin_config.h"
#include "SensorPCF85063.hpp"
#include <Wire.h>

#include "HWCDC.h"

#define BUTTON_PIN 0
HWCDC USBSerial;

SensorPCF85063 rtc;
bool isPaused = false;
uint8_t minuteP = 0;
uint8_t secondP = 0;

uint32_t lastMillis;
char previousTimeString[20] = "";
Arduino_DataBus *bus = new Arduino_ESP32SPI(LCD_DC, LCD_CS, LCD_SCK, LCD_MOSI);

Arduino_GFX *gfx = new Arduino_ST7789(bus, LCD_RST /* RST */,
                                      0 /* rotation */, true /* IPS */, LCD_WIDTH, LCD_HEIGHT, 0, 20, 0, 0);

int16_t getCenteredX(const char *text, uint8_t textSize) {
  int16_t textWidth = strlen(text) * 3 * textSize;  // 6 pixels per character in default size
  return (LCD_WIDTH - textWidth) / 2;
}

void setup() {
  USBSerial.begin(115200);
  pinMode(BUTTON_PIN, INPUT_PULLUP);

  gfx->begin();
  gfx->fillScreen(WHITE);
  pinMode(LCD_BL, OUTPUT);
  digitalWrite(LCD_BL, HIGH);

  gfx->fillRect(0, 150, LCD_WIDTH, 50, WHITE);  // Clear the area for the time
  gfx->setTextColor(BLACK);
  gfx->setTextSize(3, 3, 0);

  int16_t timeX = getCenteredX("00:00", 3);
  gfx->setCursor(timeX, 150);  // Adjust Y-coordinate as needed
  gfx->println("00:00");       // Display the new time
  if (!rtc.begin(Wire, PCF85063_SLAVE_ADDRESS, IIC_SDA, IIC_SCL)) {
    USBSerial.println("Failed to find PCF8563 - check your wiring!");
    while (1) {
      delay(1000);
    }
  }
}

void loop() {
  int buttonState = digitalRead(BUTTON_PIN);

  if (buttonState == LOW) {
    while (buttonState == LOW) { buttonState = digitalRead(BUTTON_PIN); }
    bool keepgoing = true;

    uint8_t minute = 0;
    uint8_t second = 0;
    gfx->begin();
    gfx->fillScreen(WHITE);
    pinMode(LCD_BL, OUTPUT);
    digitalWrite(LCD_BL, HIGH);

    while (keepgoing) {
      buttonState = digitalRead(BUTTON_PIN);

      if (buttonState == LOW) {
        while (buttonState == LOW) {
          buttonState = digitalRead(BUTTON_PIN);
        }

        if (!isPaused) {
          minuteP = minute;
          secondP = second;
        }
        isPaused = !isPaused;
      }

      if (millis() - lastMillis > 1000) {
        lastMillis = millis();
        if (!isPaused) {
          second++;
          if (second == 60) {
            second = 0;
            minute++;
          }
        }
        // Format the current time as a string
        char timeString[20];

        if (isPaused) {
          sprintf(timeString, "%02d:%02d", minuteP, secondP);
        } else {
          sprintf(timeString, "%02d:%02d", minute, second);
          if (minute == 1) {
            keepgoing = false;
          }
        }



        // Only update the time if it has changed
        if (strcmp(timeString, previousTimeString) != 0) {
          // Clear the previous time area by filling a small rectangle
          gfx->fillRect(0, 150, LCD_WIDTH, 50, WHITE);  // Clear the area for the time
          gfx->setTextColor(BLACK);
          gfx->setTextSize(3, 3, 0);

          int16_t timeX = getCenteredX(timeString, 3);
          gfx->setCursor(timeX, 150);  // Adjust Y-coordinate as needed
          gfx->println(timeString);    // Display the new time

          // Save the current time as the previous time
          strcpy(previousTimeString, timeString);
        }
      }
    }
  }
}
