// Victor VARIOT
#include <Wire.h> 
#include <LiquidCrystal_I2C.h>

LiquidCrystal_I2C lcd(0x3F,20,4);  // set the LCD address to 0x27 for a 16 chars and 2 line display
const int capteurHydroPin = 32;
int hydroRAW = 0;
int hydroPercent = 0;
void setup()
{
  pinMode(capteurHydroPin, INPUT);
  lcd.init();                      // initialize the lcd 
  // Print a message to the LCD.
  lcd.backlight();


  lcd.setCursor(0,0);
  lcd.print("Bienvenue dans ");
  lcd.setCursor(0,1);
  lcd.print("le pot connecte!");

  delay(3000);
}

void loop()
{
  lcd.clear();
  hydroRAW = analogRead(capteurHydroPin);
  hydroPercent = (hydroRAW*100)/2500; // experimentalement

  lcd.setCursor(0,0);
  lcd.print("Hydrometrie:");
  lcd.setCursor(0,1);
  lcd.print(String(hydroPercent) + "%");
 
  delay(1000);
}
