#! /usr/bin/env python3
# -*- coding: UTF-8 -*-
import numpy as np
import matplotlib.pyplot as plt
#Description du chemin où trouver le fichier (attention il faut remplacer les '\' par des '/' )
f = open("C:/Users/quent/OneDrive/Bureau/ENSC/TransD/Testground/02400002.TXT", "rb")
#"C:\Users\quent\OneDrive\Bureau\ENSC\TransD\Framboisier\02400001.TXT"
#! /usr/bin/env python3
# -*- coding: UTF-8 -*-

import struct
#compteur = 0;
AllRes = [[],[],[],[],[],[],[],[]]

try:
	while True:
		# Lecture 26 octets dans le fichier
		record = f.read(26)
		if len(record) != 26:
			break;
		#compteur += 1
		# Test si on est sur la ligne de #####...
		if record[:18] == b'#################\n':
			# Lit le complement et reconstitue l'enregistrement
			complement = f.read(18)
			record = record[18:] + complement

		# Ajoute un octet null tous les 3 octets a partir du 2ème caractère jusqu'à l'avant dernier
		record_4x8_octets = bytearray()
		i=1;
		while i<25:
			record_4x8_octets.append(record[i])
			if i % 3 == 0:
				record_4x8_octets.append(0) # Tous les 3 octets, on en ajoute un null
			i += 1

		# print as hex pour debug
		#print(record_4x8_octets.hex())

		# Converti l'enregistrement (tableau de bytes) en 8 entiers signés
		resultat_fois256 = struct.unpack('>iiiiiiii', record_4x8_octets)

		# Divise les résultats par 256 pour recadrer les 3 octets à gauche en conservant le signe
		resultat = []
		for i in range(len(resultat_fois256)):
			res = resultat_fois256[i]//256
			AllRes[i].append(res)
			
	#Construction du signal temporel
	Fe = 250000 #freq d'échantillonage 
	tstep = 1 / Fe #interval de temps 
	N = len(AllRes[0][:]) #nombre d'échantillon 
	print("nombre de messure : " + str(N) , "temps de l'enregistrement : " + str(tstep*N/1000) + " s")
	Fs = 500
	t = np.linspace(0, (N-1) * tstep, N) #tableau du temps
	fstep  = Fs/N #interval des freq
	freq = np.linspace(0, (N-1) * fstep, N) 

	"""for i in range(len(AllRes)):
		y = AllRes[i]
		plt.plot(t,y)"""
		
	#Réalisation de la fft et affichage
	
	for i in range(2):
		y = AllRes[i][:]
		x = np.fft.fft(y)
		xMag = abs(x)
		fig, (ax1, ax2) = plt.subplots(2, 1)

		ax1.plot(t, y)
		ax1.set_ylabel('tension')
		ax1.set_xlabel('time (s)')
		ax1.set_title("Tension renvoyée par le capteur " + str(i+1) + " en fonction du temps")

		ax2.plot(freq, xMag)
		ax2.set_xlabel('fréquence (Hz)')
		ax2.set_ylabel('Amplitude')
		ax2.set_title("Spectre des fréquences du signel renvoyé par le capteur " + str(i+1))

	plt.show()

except IOError:
	# Traitement d'erreurs a faire ici...
	pass

finally:
	f.close()