import math
import numpy as np
import matplotlib.pyplot as plt

import struct

#"C:\Users\quent\OneDrive\Bureau\ENSC\TransD\Framboisier\02400001.TXT"
#! /usr/bin/env python3
# -*- coding: UTF-8 -*-

AllRes = [[],[],[],[],[],[],[],[]]
for i in range(31,34): #choix des fichiers ouvert (utilisation d'un chemin relatif)
	compteur = 0
	if i < 10: #suivant  si le fichier fini par un nombre  inférieur ou supérieur à 10 on complète notre lien soit par "0"+i soit par i
		complement_link = "0" + str(i) 
	else:
		complement_link = str(i)
	link = "Framboisier/024000" + complement_link +".TXT"

	f = open(link , "rb")#ouvertuture  du fichier txt traiter
	
	while True:
		# Lecture 26 octets dans le fichier
		record = f.read(26)
		if len(record) != 26:
			break;
		#compteur += 1
		# Test si on est sur la ligne de #####...
		if record[:18] == b'#################\n':
			# Lit le complement et reconstitue l'enregistrement
			complement = f.read(18)
			record = record[18:] + complement

		# Ajoute un octet null tous les 3 octets a partir du 2ème caractère jusqu'à l'avant dernier
		record_4x8_octets = bytearray()
		i=1;
		while i<25:
			record_4x8_octets.append(record[i])
			if i % 3 == 0:
				record_4x8_octets.append(0) # Tous les 3 octets, on en ajoute un null
			i += 1

		# Converti l'enregistrement (tableau de bytes) en 8 entiers signés
		resultat_fois256 = struct.unpack('>iiiiiiii', record_4x8_octets)

		# Divise les résultats par 256 pour recadrer les 3 octets à gauche en conservant le signe
		resultat = []
		for i in range(len(resultat_fois256)):
			res = resultat_fois256[i] // 256 * 20
			AllRes[i].append(res)

	#a la fin de chaque fichier de mesure en trouve une série de 19 zéros écrit par le capteur 
	for i in range(19): #cette boucle permet de retirer les 19 zéros du signal
		for j in range(8):
			AllRes[j].pop()
	
	f.close()#fermeturedu fichier txt

fig, (ax1, ax2) = plt.subplots(2, 1) #Création de la figure à 2 plots 

Fe = 250000 #Fréquence d'échantillonage
tstep = 1 / Fe #Time spacing
y = AllRes[0][:] #Signal renvoyé par le premier capteur
N = len(y) #nb de points
t = np.linspace(0, (N-1) * tstep, N) #Tableau des temps

#Légende du plot 1
ax1.set_ylabel('Tension (nV)')
ax1.set_xlabel('Time (s)')
ax1.set_title("Tension renvoyée par le capteur 1 en fonction du temps")

#Légende du plot 2
ax2.set_xlabel('Fréquence (Hz)')
ax2.set_ylabel('Amplitude')
ax2.set_title("Spectre des fréquences du signal renvoyé par le capteur 1")

#calcul de la FFT
sp = np.fft.fft(y,Fe)
f = np.fft.fftfreq(Fe,tstep) #axe des abscisses: fréquence

#Définition des courbes des plots
ax1.plot(t,y)
ax2.plot(f,abs(sp))

#Lancement de l'affichage du plot
plt.show()