#! /usr/bin/env python3
# -*- coding: UTF-8 -*-

import struct

# ouverture fichier en mode binaire
f = open("VS407AF.TXT", "rb")
compteur = 0;

try:
    while True:
        # Lecture 26 octets dans le fichier
        record = f.read(26)
        if len(record) != 26:
            break;
        compteur += 1
        # Test si on est sur la ligne de #####...
        if record[:18] == b'#################\n':
            # Lit le complement et reconstitue l'enregistrement
            complement = f.read(18)
            record = record[18:] + complement

        # Ajoute un octet null tous les 3 octets a partir du 2ème caractère jusqu'à l'avant dernier
        record_4x8_octets = bytearray()
        i=1;
        while i<25:
            record_4x8_octets.append(record[i])
            if i % 3 == 0:
                record_4x8_octets.append(0) # Tous les 3 octets, on en ajoute un null
            i += 1

        # print as hex pour debug
        #print(record.hex())
        #print(record_4x8_octets.hex())

        # Converti l'enregistrement (tableau de bytes) en 8 entiers signés
        resultat_fois265 = struct.unpack('>iiiiiiii', record_4x8_octets)

        # Divise les résultats par 256 pour recadrer les 3 octets à gauche en conservant le signe
        resultat = []
        for R in resultat_fois265:
            resultat.append(R//256) # // => division entière

        # Affiche les 8 valeurs:
        print(resultat)

except IOError:
    # Traitement d'erreurs a faire ici...
    pass

finally:
    f.close()
