import csv

#Notre fichier csv a été obtenu via le code du projet transdi 2019-2020.
#Il est composé de lignes de valeurs espacées d'une ligne vide
#Ses valeurs correspondent aux 8 valeurs des capteurs à chaque unité de temps

#On crée une liste contenant 8 listes avec les valeurs pour chaque capteurs
valeurs = [[],[],[],[],[],[],[],[]]

#Permet d'ouvrir le fichier csv de lecture (r correspond au mode de lecture,
#ici lecture seule)
with open("CSVFILE.CSV",'r') as infile:
    lecture = csv.reader(infile) #On définit un objet qui lit notre fichier

#Pour les données que nous utilisons ici, nous réduissons le nombre de points trop nombreux
#pour être lu par Ossia Score. On en prend 1 sur 1000.
    compteur=0;

    for row in lecture: #On boucle sur chaque ligne du fichier
        if row: #Agit seulement sur la ligne n'est pas vide
            if compteur%50==0:
                for i in range(8):
                    valeurs[i].append(row[i])
            compteur=compteur+1

#Il faut traduire les valeurs en les remettant sur une échelle de 0 à 1 pour
#qu'elles soient compatibles avec Ossia Score :
for i in range(len(valeurs)):
    for j in range(len(valeurs[i])):
        valeurs[i][j] = float(valeurs[i][j])
        valeurs[i][j] = valeurs[i][j] + 8398930 #on remet tout en positif
        valeurs[i][j] = valeurs[i][j] / 16777216 #On met sur une échelle de 0 à 1
        valeurs[i][j] = str(valeurs[i][j])

#On récupère le script du fichier JSON
with open("scriptsignaux.json",'r') as infile:
    script = infile.readlines()

#Maintenant qu'on a nos données dans une liste, on écrit les fichiers JSON :
for i in range(8):
    with open(f"capteur{i}.layer",'w') as outfile: #On écrit un nouveau fichier (w = écriture seule) pour chaque capteur
        for j in range(48): #Les 48 premières lignes du script sont les mêmes pour tous les fichiers
            outfile.write(script[j]) #lire les lignes du fichier JSON et les copier dans le fichier

        #Insertion des valeurs : on commence par calculer l'échantillonnage (nb
        #de points)
        ech = 1 / (len(valeurs[i]) - 1)

        #Dernière valeur:
        outfile.write('{\n"uuid": "1e7cb83f-4e47-4b14-814d-2242a9c75991",\n"ObjectName": "CurveSegmentModel",')
        outfile.write(f'"id": {len(valeurs[i])-2},')
        outfile.write(f'"Previous": {len(valeurs[i])-3},')
        outfile.write('"Following": null,')
        outfile.write(f'"Start": [ {ech*(len(valeurs[i])-2)}, {valeurs[i][len(valeurs[i])-2]} ],')
        outfile.write(f'"End": [ 1.0, {valeurs[i][len(valeurs[i])-1]} ],')
        outfile.write('"Power": 1.0\n},')

        for j in range(len(valeurs[i]) - 3, 0, -1):
            outfile.write('{\n"uuid": "1e7cb83f-4e47-4b14-814d-2242a9c75991",\n"ObjectName": "CurveSegmentModel",')
            outfile.write(f'"id": {j},')
            outfile.write(f'"Previous": {j-1},')
            outfile.write(f'"Following": {j+1},')
            outfile.write(f'"Start": [ {ech*(j)}, {valeurs[i][j-1]} ],')
            outfile.write(f'"End": [ {ech*(j+1)}, {valeurs[i][j]} ],')
            outfile.write('"Power": 1.0\n},')

        #Première valeur:
        outfile.write('{\n"uuid": "1e7cb83f-4e47-4b14-814d-2242a9c75991",\n"ObjectName": "CurveSegmentModel",')
        outfile.write('"id": 0,')
        outfile.write('"Previous": null,')
        outfile.write('"Following": 1,')
        outfile.write('"Start": [ 0.0, 0.0 ],')
        outfile.write(f'"End": [ {ech*1}, {valeurs[i][0]} ],')
        outfile.write('"Power": 1.0\n}')

        for j in range(34): #les lignes 69 à 102 sont les même pour tous les fichiers
            outfile.write(script[68 + j])