#!/bin/bash

# pré-requis 1: 
# Installer Hugo sur sa machine Debian. 
# wget https://github.com/gohugoio/hugo/releases/download/v0.89.4/hugo_extended_0.89.4_Linux-64bit.deb
# dpkg -i ./hugo_extended_0.89.4_Linux-64bit.deb


# pré-requis 2 : 
# création d'un nouveau dépôt sur le gitea du fablab (ou autre git public) par un adminsys du fablab. Dans la suite de ce script, il sera mis en mémoire dans la variable $depotgit .

# pré-requis 3 (optionnel mais pratique) :
# ajout de sa clé SSH publique sur gitea du fablab pour 'git push' en SSH


#On se place dans le dossier où l'on veut créer un nouveau site en Hugo, puis :
cd .

#On définit les variables (qui seront passées en argument au lancement du fichier bash):
dossierlocal=$1 #nom du dossier du site web sur ton ordi (ATTENTION: ne jamais l'appeler "portfolios" ! pour une raison inconnue: ça ne marche pas.
lienpublicgithubdutheme=$2 #lieu où se trouve le theme qu'on veut copier sur Internet (github.com/----.git)
depotgit=$3 #dépôt git distant sur lequel on va collaborer ou dont on va se servir pour le déploiement. Pour la variable $depotgit, utiliser (si clé SSH confirmée) "ssh://gitea@git.cohabit.fr:22222/admin-sys/portfolios-theme.git" ou alors "https://github.com/<votre-nom-d-utilisateur-debian>/<$dossierlocal>.git"

# Exemple :
# dossierlocal=monportfolio
# lienpublicgithubdutheme=git@github.com:dzello/reveal-hugo.git
# depotgit=ssh://gitea@git.cohabit.fr:22222/admin-sys/portfolios.git

#On crée un nouveau projet de site web en Hugo:
hugo new site $dossierlocal && cd $dossierlocal/ 

#Vérification pour voir s'il y a bien une structure Hugo dans le dossier du nouveau projet de site web et on se place dans le sous-dossier "themes":
ls && cd ./themes/

#On télécharge le template du site web avec lequel on souhaite travailler dans le sous-dossier "themes" 
#et on affiche s'il y a bien eu téléchargement du template:
git clone $lienpublicgithubdutheme && cd ./*
ls -la

#on supprime les éventuels fichiers .git existant dans le thème:
rm -rf .git .gitignore
ls -la

#on retourne à la racine du projet du site web
cd ../..

#copier site web exemple à la racine du dossier du site web en local
cp -r ./themes/*/exampleSite/* .
cp -r ./themes/*/layouts .
 
#création du dossier public/ à la racine du site
hugo --destination public

#on le convertit en dépôt Git
git init

#on fait un first commit afin que le dépôt devienne actif et prêt à être mis en ligne sur le Gitea de la forge.openlux.fr
git status
git add . 
git status
git commit -m "premier commit"

#message de rappel pour créer un nouveau dépôt sur le git collaboratif en ligne 
read -p "Avez-vous créé votre dépôt git public? (oui/non)" arg1
while [[ $arg1 -ne "oui" ]] 
do
	read -p "Avez-vous créé votre dépôt git public? (oui/non)" arg1
	if [[ $arg1 -eq "oui" ]]
	then
    		break
 	fi
done #alors la boucle s'arrête et se poursuit

#Mise en ligne dans un dépôt git distant (comme indiqué en argument lors du lancement du script). On l'appelle "origin"
git remote add origin $depotgit
git remote -v
git push -u origin master




