clear all; close all; clc; %nettoyage

format short; %format d'affichage court des nombres

pkg load io; %chargement du paquet IO pour pouvoir utiliser la commande csv2cell

nom_csv = input('Entrer le nom du tableau .csv : ','s');
separateur = input('Quel sparateur ? (normalement ";") ', 's');

tableau = csv2cell(nom_csv, separateur);  %LA fonction cl !
taille = size(tableau); %mesure la taille du tableau
tableau = tableau(2:taille(1,1),1:6); %retire la premire ligne avec les en-ttes

%affichage du dbut et de la fin du tableau
printf('\n Premire ligne du tableau : ');
disp(tableau(1, :));
printf('\n Dernire ligne du tableau : ');
disp(tableau((taille(1,1)-1), :));
printf('\n');

%x_min/temps_debut et x_max/temps/fin pour le graphique
temps_debut = input("A partir de ? (format = jj/mm/aaaa hh:mm) : ",'s');
temps_fin = input("Jusqu' ? (format = jj/mm/aaaa hh:mm) : ",'s');

%extraction de la premire colonne (date et heure) dans le tableau temps_tableau
temps_tableau=tableau(:,1);

%cherche  quelle position du tableau temps_debut = temps_tableau ... L'AUTRE fonction cl !
pos_debut=strmatch(temps_debut, temps_tableau);
pos_fin=strmatch(temps_fin, temps_tableau);

%testtesttest
%pos_debut_test=strncmp(temps_debut, temps_tableau, 16);
%pos_fin_test=strncmp(temps_fin, temps_tableau, 16);
pos_debut_test=strcmp(temps_debut, temps_tableau);
pos_fin_test=strcmp(temps_fin, temps_tableau);

%extraction et conversion en char dans temps_char de la partie du tableau entre pos_debut et pos_fin
temps_char=char(temps_tableau(pos_debut:pos_fin,1));

%extraction du jour, mois, anne, heure, minute de temps_char et conversion en dcimal
jj=(temps_char(:,1) - 48) * 10 + temps_char(:,2) - 48;
mm=(temps_char(:,4) - 48) * 10 + temps_char(:,5) - 48;
aaaa=(temps_char(:,7) - 48) * 1000 + (temps_char(:,8) - 48) * 100 + (temps_char(:,9) - 48) * 10 + temps_char(:,10) - 48;
hh=(temps_char(:,12) - 48) * 10 + temps_char(:,13) - 48;
min=(temps_char(:,15) - 48) * 10 + temps_char(:,16) - 48;

%conversion du temps en minutes
x_minutes=aaaa*525600 + mm*43800 + jj*1440 + hh*60 + min;
x_minutes=x_minutes - x_minutes(1,1); %temps en minutes depuis le dmarrage, pour le graphique

%conversions des donnes tu tableau cell->double et extraction par colonne entre pos_debut et pos_fin
tension_V=cell2mat(tableau(pos_debut:pos_fin,2));     %tension en volt V
courant_A=cell2mat(tableau(pos_debut:pos_fin,3));     %courant en ampre A
cos_phi=cell2mat(tableau(pos_debut:pos_fin,4));       %cos(phi) ou "facteur de puissance"
puissance_W=cell2mat(tableau(pos_debut:pos_fin,5));   %puissance consomme P = U * I * cos(phi) - calcul dj fait par le voltcraft
puissance_VA=cell2mat(tableau(pos_debut:pos_fin,6));  %puissance apparente P = U * I - calcul dj fait par le voltcraft

%Menu pour choisir les donnes  tracer
printf('\n\t Choix des donnes  tracer : \n\n');
printf('Tension V \t\t\t\t\t -> 1\n');
printf('Courant A \t\t\t\t\t -> 2\n');
printf('Facteur de puissance (cos(phi)) \t\t -> 3\n');
printf('Puissance consomme (P = U * I * cos(phi)) \t -> 4\n');
printf('Puissance apparente (P = U * I) \t\t -> 5\n');
printf('Pour quitter ce menu \t\t\t -> 0\n');
printf('\n\t');

%Variable choix
choix=input('Choix : ');

%boucle de choix pour tracer les courbes  la vole et les sauvegarder en .svg
while choix ~= 0,
  switch choix
    case 1
      plot(x_minutes, tension_V);
      title('Tension');xlabel('Temps (minutes)');ylabel('Tension (V)');
      print ('tension', '-dsvg');
    case 2
      plot(x_minutes, courant_A);
      title('Courant');xlabel('Temps (minutes)');ylabel('Courant (A)');
      print ('courant', '-dsvg');
    case 3
      plot(x_minutes, cos_phi);
      title('Facteur de puissance');xlabel('Temps (minutes)');ylabel('Cos(Phi)');
      print ('cos_phi', '-dsvg');
    case 4
      plot(x_minutes, puissance_W);
      title('Puissance consomme P = U x I x cos(Phi)');xlabel('Temps (minutes)');ylabel('Puissance (W)');
      print ('P_consommee', '-dsvg');
    case 5
      plot(x_minutes, puissance_VA);
      title('Puissance apparente P = U x I');xlabel('Temps (minutes)');ylabel('Puissance (VA)');
      print ('P_apparente', '-dsvg');
    otherwise
      printf('Rentrez un choix entre 1 et 5 ! \n');
  end
  choix=input('Autres donnes  tracer : ');
end
close;  %ferme la fentre du graphique



